/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.spell.custom.editor;

import com.mojang.serialization.Codec;
import dev.xkmc.l2serial.util.Wrappers;
import dev.xkmc.youkaishomecoming.content.spell.custom.annotation.ArgField;
import dev.xkmc.youkaishomecoming.content.spell.custom.annotation.ArgGroup;
import dev.xkmc.youkaishomecoming.content.spell.custom.annotation.EnumArgEntry;
import dev.xkmc.youkaishomecoming.content.spell.custom.annotation.ExpArgEntry;
import dev.xkmc.youkaishomecoming.content.spell.custom.annotation.IArgEntry;
import dev.xkmc.youkaishomecoming.content.spell.custom.annotation.IntArgEntry;
import dev.xkmc.youkaishomecoming.content.spell.custom.annotation.UnitArgEntry;
import dev.xkmc.youkaishomecoming.content.spell.custom.data.ISpellFormData;
import dev.xkmc.youkaishomecoming.content.spell.custom.editor.DoubleValue;
import dev.xkmc.youkaishomecoming.content.spell.custom.editor.OptionGroup;
import dev.xkmc.youkaishomecoming.content.spell.custom.editor.OptionHolder;
import dev.xkmc.youkaishomecoming.content.spell.custom.editor.OptionPair;
import dev.xkmc.youkaishomecoming.content.spell.custom.editor.SimpleValue;
import dev.xkmc.youkaishomecoming.content.spell.custom.screen.ClientCustomSpellHandler;
import it.unimi.dsi.fastutil.doubles.Double2DoubleFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.Options;
import net.minecraft.client.gui.components.OptionsList;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class SpellOptionInstances<T extends Record> {
    private OptionGroup<T> builder;
    private List<OptionHolder<?>> list;
    private Runnable listener;

    private SimpleValue<Integer> createLinear(String name, int def, int low, int high) {
        String key = "youkaishomecoming.custom_spell." + name;
        return new SimpleValue<Integer>(new OptionInstance(key, v -> Tooltip.m_257550_((Component)Component.m_237115_((String)(key + ".desc"))), Options::m_231900_, (OptionInstance.ValueSet)new OptionInstance.IntRange(low, high), (Object)def, v -> this.update()), def);
    }

    private DoubleValue createDouble(String name, OptionInstance.CaptionBasedToString<Double> caption, double def, Double2DoubleFunction toUnit, Double2DoubleFunction fromUnit) {
        String key = "youkaishomecoming.custom_spell." + name;
        return new DoubleValue((OptionInstance<Double>)new OptionInstance(key, v -> Tooltip.m_257550_((Component)Component.m_237115_((String)(key + ".desc"))), (e, v) -> caption.m_231580_(e, (Object)((Double)fromUnit.apply(v))), (OptionInstance.ValueSet)OptionInstance.UnitDouble.INSTANCE, (Object)((Double)toUnit.apply((Object)def)), v -> this.update()), toUnit, fromUnit, def);
    }

    private <E extends Enum<E>> SimpleValue<E> createEnum(String name, E[] values, E def) {
        String key = "youkaishomecoming.custom_spell." + name;
        return new SimpleValue<E>(new OptionInstance(key + ".title", OptionInstance.m_231498_(), (e, v) -> Component.m_237115_((String)(key + "." + v.name().toLowerCase(Locale.ROOT))), (OptionInstance.ValueSet)new OptionInstance.Enum(Arrays.asList(values), Codec.INT.xmap(e -> values[e], Enum::ordinal)), def, p_268018_ -> this.update()), def);
    }

    private DoubleValue createExp(String name, double def, double a, double b, int decimal) {
        double factor = Math.pow(10.0, decimal);
        return this.createDouble(name, (OptionInstance.CaptionBasedToString<Double>)((OptionInstance.CaptionBasedToString)(e, v) -> Component.m_237110_((String)"options.generic_value", (Object[])new Object[]{e, v})), def, v -> Math.log(v / b + 1.0) / Math.log(a + 1.0), u -> (double)Math.round((Math.pow(a + 1.0, u) - 1.0) * b * factor) / factor);
    }

    private DoubleValue createPercent(String name, double def) {
        return this.createDouble(name, (OptionInstance.CaptionBasedToString<Double>)((OptionInstance.CaptionBasedToString)(e, v) -> Component.m_237110_((String)"options.percent_value", (Object[])new Object[]{e, Math.round(v * 100.0)})), def, v -> v, u -> (double)Math.round(u * 100.0) * 0.01);
    }

    private OptionHolder<?> create(ArgField entry, Object obj) {
        String name = entry.field().getName();
        if (entry.range() instanceof UnitArgEntry) {
            return this.createPercent(name, ((Number)obj).doubleValue());
        }
        IArgEntry iArgEntry = entry.range();
        if (iArgEntry instanceof IntArgEntry) {
            IntArgEntry arg = (IntArgEntry)iArgEntry;
            return this.createLinear(name, ((Number)obj).intValue(), arg.low(), arg.high());
        }
        iArgEntry = entry.range();
        if (iArgEntry instanceof ExpArgEntry) {
            ExpArgEntry arg = (ExpArgEntry)iArgEntry;
            return this.createExp(name, ((Number)obj).doubleValue(), arg.base(), arg.factor(), arg.decimal());
        }
        iArgEntry = entry.range();
        if (iArgEntry instanceof EnumArgEntry) {
            EnumArgEntry arg = (EnumArgEntry)iArgEntry;
            return this.createEnum(name, (Enum[])Wrappers.cast((Object)arg.vals()), (Enum)Wrappers.cast((Object)obj));
        }
        throw new IllegalArgumentException("Argument Type " + entry.getClass() + " is invalid");
    }

    private <E> OptionGroup<E> create(List<OptionHolder<?>> list, ArgGroup entry, E obj) throws Exception {
        ArrayList<OptionPair> pairs = new ArrayList<OptionPair>();
        for (ArgField e : entry.list()) {
            Object sub = e.field().getAccessor().invoke(obj, new Object[0]);
            IArgEntry iArgEntry = e.range();
            if (iArgEntry instanceof ArgGroup) {
                ArgGroup group = (ArgGroup)iArgEntry;
                pairs.add(new OptionPair(e, this.create(list, group, sub)));
                continue;
            }
            OptionHolder<?> opt = this.create(e, sub);
            list.add(opt);
            pairs.add(new OptionPair(e, opt));
        }
        return new OptionGroup(entry, pairs);
    }

    @Nullable
    public static <T extends Record> SpellOptionInstances<T> create(T obj) {
        try {
            SpellOptionInstances<T> ans = new SpellOptionInstances<T>();
            ans.list = new ArrayList();
            ArgGroup group = ArgGroup.of(obj.getClass());
            ans.builder = ans.create(ans.list, group, obj);
            return ans;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private SpellOptionInstances() {
    }

    public void add(OptionsList widget, Runnable listener) {
        this.listener = listener;
        int n = this.list.size();
        for (int i = 0; i < n; i += 2) {
            if (i == n - 1) {
                widget.m_232528_(this.list.get(i).option());
                continue;
            }
            widget.m_232530_(this.list.get(i).option(), this.list.get(i + 1).option());
        }
    }

    private void update() {
        if (this.listener != null) {
            this.listener.run();
        }
    }

    public void reset() {
        for (OptionHolder<?> e : this.list) {
            e.reset();
        }
    }

    @Nullable
    public T build() {
        try {
            return (T)((Record)this.builder.get());
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public void save() {
        T val = this.build();
        if (val == null) {
            return;
        }
        ClientCustomSpellHandler.sendToPlayer((ISpellFormData)val);
    }
}

